/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
import java.io.PrintWriter; import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class WebAgent extends AgentBase {
	private static final String [] items = {
	"AUTH_TYPE","CGI_PATH_INFO","CONTENT_LENGTH","CONTENT_TYPE","GATEWAY_INTERFACE","HTTPS","HTTP_ACCEPT","HTTP_ACCEPT_ENCODING","HTTP_ACCEPT_LANGUAGE","HTTP_CONNECTION","HTTP_HOST","HTTP_USER_AGENT","PATH_INFO","PATH_INFO_DECODED","PATH_TRANSLATED","QUERY_STRING","QUERY_STRING_DECODED","REMOTE_ADDR","REMOTE_HOST","REMOTE_IDENT","REMOTE_USER","REQUEST_METHOD","SCRIPT_NAME","SERVER_ADDR","SERVER_NAME","SERVER_PORT","SERVER_PROTOCOL","SERVER_SOFTWARE"};
	public void NotesMain() {
		PrintWriter out = getAgentOutput();
		Document docContext = null;
		try {
			Session session = getSession();
			AgentContext agentContext = session.getAgentContext();
			StringBuffer buf=new StringBuffer();
			buf.append("Content-Type: text/html\n")
					//.append ("Content-length: 1876\n")
					/*Die content-length muss weggelassen werden, wenn sie nicht 
					* exakt bekannt ist. Ist der Wert zu gro, wartet der Browser
					* vergeblich auf scheinbar fehlende Bytes */
			.append("Set-Cookie: variable=Java+at+Domino;")
			.append("path=/my/Path;domain=192.168.1.201;")
			.append("expires=Thu 1-Jan-2099 00:00:00 GMT\n\n")
					//ein expires Datum in der Vergangenheit lscht ein Cookie
			.append("<html><head>\n")
			.append("<title>Domino Web Agent</title>\n<style>\n")
			.append("\tbody {font-family:Helvetica,Arial,sans-serif;}\n")
			.append("\th1 {color:#FF00FF;}\n</style>\n</head>\n")
			.append("<body>\n<h1>Herzlich Willkommen</h1>\n")
			.append("\nDies ist ein Domino Web Agent\n")
			.append("<br/>AgentContext: ")
			.append((agentContext == null ? " nicht vorhanden "
							: agentContext.getEffectiveUserName()))
			.append("<br/>User: " + session.getUserName())
			.append("<br/>HeapSize: " + Runtime.getRuntime().totalMemory());
			out.println (buf.toString());
			docContext = agentContext.getDocumentContext();
			if (docContext == null) {
				out.println ("Kein Context Dokument vorhanden.");
			} else {
				out.println("<br/>ContextDocument (created): "
						+ docContext.getCreated().toString());
				for (int i = 0, k = items.length; i < k; i++) {
					out.println("<br/>ContextDocument (" + items[i] + "): "
							+ docContext.getItemValueString(items[i]));
				}
			}
			out.println ("\n</body>\n</html>\n");			
		} catch(Exception e) {
			e.printStackTrace(out);
		} finally {
			if (docContext != null) {
				try {
					docContext.recycle();
				} catch (NotesException e1) {
					e1.printStackTrace();
				}
			}
		}
	}
}
